<?php
/* --------------------------------------------------------------
 PostfinanceBasicLanguage.php 2020-01-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 23 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class PostfinanceBasicLanguage
 * @package Gambio\Core\Configuration\Types
 */
class PostfinanceBasicLanguage implements ConfigurationType
{
    private const OPTIONS_DATA = [
        [
            'value' => 'Selected language',
            'text'  => 'Selected language',
        ],
        [
            'value' => 'de_DE',
            'text'  => 'de_DE',
        ],
        [
            'value' => 'fr_FR',
            'text'  => 'fr_FR',
        ],
        [
            'value' => 'it_IT',
            'text'  => 'it_IT',
        ],
        [
            'value' => 'en_US',
            'text'  => 'en_US',
        ],
        [
            'value' => 'es_ES',
            'text'  => 'es_ES',
        ],
        [
            'value' => 'nl_NL',
            'text'  => 'nl_NL',
        ],
        [
            'value' => 'nl_BE',
            'text'  => 'nl_BE',
        ],
        [
            'value' => 'no_NO',
            'text'  => 'no_NO',
        ],
        [
            'value' => 'tr_TR',
            'text'  => 'tr_TR',
        ],
    ];
    
    
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        return Options::fromArray(self::OPTIONS_DATA);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}